# sig11 shell addons


# If not running interactively, don't do anything
case $- in
    *i*) ;;
      *) return;;
esac

# Nor if it's not bash
if [ -z "$BASH" ] || [ "$BASH" != "/bin/bash" ]; then
	return
fi


# add local path
if [ -d ~/bin ] ; then
    PATH=~/bin:$PATH
fi
export PATH


# check the window size after each command and, if necessary,
# update the values of LINES and COLUMNS.
shopt -s checkwinsize


# don't put duplicate lines or lines starting with space in the history.
# See bash(1) for more options
HISTCONTROL=ignoreboth

# append to the history file, don't overwrite it
shopt -s histappend

# for setting history length see HISTSIZE and HISTFILESIZE in bash(1)
HISTSIZE=1000
HISTFILESIZE=2000
export HISTCONTROL HISTSIZE HISTFILESIZE


# make less more friendly for non-text input files, see lesspipe(1)
[ -x /usr/bin/lesspipe ] && eval "$(SHELL=/bin/sh lesspipe)"
LESSCHARSET="UTF-8"
LESS="-M -S -I -R"
PAGER=less
export LESSCHARSET LESS PAGER


# ls coloring
if [ -x /usr/bin/dircolors ] ; then
    # set up the color-ls environment variables:
    if [ -r ~/.dir_colors ] ; then
        eval `dircolors -b ~/.dir_colors`
    elif [ -r /etc/DIR_COLORS ] ; then
        eval `dircolors -b /etc/DIR_COLORS`
    else
        eval `dircolors -b`
    fi
fi


# Further options for the 'ls' command are in /etc/DIR_COLORS.
unalias ls 2>/dev/null
if [ "`id -u`" -eq 0 ] ; then
    LS_OPTIONS='-a -N --color=tty -T 0';
else
    LS_OPTIONS='-N --color=tty -T 0';
fi
export LS_OPTIONS
alias ls='ls $LS_OPTIONS'


# aliases for the masses
alias ll='ls -alF'
alias la='ls -la'
alias l='ls -l'
alias ls-l='ls -l'
alias o='less'
alias ..='cd ..'
alias ...='cd ../..'
alias unix2dos='recode lat1..ibmpc'
alias dos2unix='recode ibmpc..lat1'
alias rehash='hash -r'
alias fuck='sudo $(history -p \!\!)'


# set prompt
set -p
if [ "$UID" -eq 0 ] ; then
    #PS1="\h:\w # "
    PS1='\[\033[01;31m\]\h\[\033[00m\]:\[\033[01;34m\]\w\[\033[00m\] # '
elif [ "$UID" -lt 500 ] ; then
    PS1='\[\033[01;33m\]\u@\h\[\033[00m\]:\[\033[01;34m\]\w\[\033[00m\] # '
else
    #PS1="\u@\h:\w > "
    PS1='\[\033[01;32m\]\u@\h\[\033[00m\]:\[\033[01;34m\]\w\[\033[00m\] > '
fi
PS2='> '
ignoreeof=0
export PS1 PS2 ignoreeof


# set title via prompt command for xterm, screen, etc.
case "$TERM" in
    xterm*|uxterm*|rxvt*|kterm*|Eterm*|screen*)
        PROMPT_COMMAND='echo -ne "\033]0;${USER}@${HOSTNAME}\007"'
        ;;
    *)
        ;;
esac


# include bash completion stuff
if [ -f ~/.bash_completion ]; then
    . ~/.bash_completion
fi


# disable bell
echo -ne '\033[11;0]'
